/*
 * @(#)RERApplicationModel.java  1.0  2006-06-18
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.rer;

import ch.hslu.cm.app.action.Arrangeable;
import ch.hslu.cm.rer.diagram.EntityFigure;
import ch.hslu.cm.rer.diagram.RelationalERDiagram;
import ch.hslu.cm.rer.diagram.RelationshipFigure;
import ch.hslu.cm.rer.model.*;
import ch.randelshofer.html.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.ActionUtil;
import org.jhotdraw.app.action.edit.CopyAction;
import org.jhotdraw.app.action.edit.CutAction;
import org.jhotdraw.app.action.edit.PasteAction;
import org.jhotdraw.app.action.edit.RedoAction;
import org.jhotdraw.app.action.edit.UndoAction;
import org.jhotdraw.app.action.file.ClearFileAction;
import org.jhotdraw.app.action.file.ExportFileAction;
import org.jhotdraw.app.action.file.LoadFileAction;
import org.jhotdraw.app.action.file.NewFileAction;
import org.jhotdraw.app.action.file.OpenFileAction;
import org.jhotdraw.app.action.file.PrintFileAction;
import org.jhotdraw.app.action.file.SaveFileAction;
import org.jhotdraw.app.action.view.ToggleViewPropertyAction;
import org.jhotdraw.app.action.view.ViewPropertyAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.TextAreaCreationTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;
/**
 * RERApplicationModel.
 *
 * @author Werner Randelshofer.
 * @version 1.0 2006-06-18 Created.
 */
public class RERApplicationModel extends DefaultApplicationModel {
   /* private*/ final static double[] scaleFactors = {5, 4, 3, 2, 1.5, 1.25, 1, 0.75, 0.5, 0.25, 0.10};
    private static class ToolButtonListener implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;
        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }
        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == ItemEvent.SELECTED) {
                editor.setTool(tool);
            }
        }
    }
    /**
     * This editor is shared by all projects.
     */
    private DefaultDrawingEditor sharedEditor;
    
    private HashMap<String,Action> actions;
    
    /** Creates a new instance. */
    public RERApplicationModel() {
    }
    
    @Override
    public ActionMap createActionMap(Application a, View v) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.rer.Labels");
        AbstractAction aa;
        ActionMap am=super.createActionMap(a, v);
        
        am.put(ExportFileAction.ID, new ExportFileAction(a,v));
        am.put(CompareRERModelsAction.ID, new CompareRERModelsAction(a,v));
        am.put("toggleOptionsPanel", aa = new ToggleViewPropertyAction(a,v, "optionsVisible"));
        labels.configureAction(aa, "workAssignment");
        am.put("toggleGrid", aa = new ToggleViewPropertyAction(a,v, "gridVisible"));
        labels.configureAction(aa, "grid");
        am.put("pArrangeHorizontal", aa = new ViewPropertyAction(a,v, "arrangement", Arrangeable.Arrangement.HORIZONTAL));
        labels.configureAction(aa, "arrangeHorizontal");
        am.put("pArrangeVertical", aa = new ViewPropertyAction(a,v, "arrangement", Arrangeable.Arrangement.VERTICAL));
        labels.configureAction(aa, "arrangeVertical");
        am.put("pArrangeCascade", aa = new ViewPropertyAction(a,v, "arrangement", Arrangeable.Arrangement.CASCADE));
        labels.configureAction(aa, "arrangeOverlap");
        for (double sf : scaleFactors) {
            am.put((int) (sf*100)+"%",
                    aa = new ViewPropertyAction(a,v, "scaleFactor", Double.TYPE, new Double(sf))
                    );
            aa.putValue(Action.NAME, (int) (sf*100)+" %");
            
        }
        return am;
    }
    
    public DefaultDrawingEditor getSharedEditor() {
        if (sharedEditor == null) {
            sharedEditor = new DefaultDrawingEditor();
        }
        return sharedEditor;
    }
    
    @Override
    public void initView(Application a, View p) {
        if (a.isSharingToolsAmongViews()) {
            ((RERView) p).setDrawingEditor(getSharedEditor());
        }
    }
    private void addStandardButtonsTo(JToolBar tb, Application app,View v) {
        ActionMap am=app.getActionMap(v);
        if (am.get(ClearFileAction.ID) != null) {
            tb.add(am.get(ClearFileAction.ID));
        } else {
            tb.add(am.get(NewFileAction.ID));
        }
        if (am.get(LoadFileAction.ID) != null) {
            tb.add(am.get(LoadFileAction.ID));
        } else {
            tb.add(am.get(OpenFileAction.ID));
        }
tb.add(am.get(SaveFileAction.ID));
tb.add(am.get(PrintFileAction.ID));
tb.addSeparator();
tb.add(am.get(UndoAction.ID));
tb.add(am.get(RedoAction.ID));
tb.addSeparator();
tb.add(am.get(CutAction.ID));
tb.add(am.get(CopyAction.ID));
tb.add(am.get(PasteAction.ID));
    }
    private void addCreationButtonsTo(JToolBar tb, final DrawingEditor editor) {
        // AttributeKeys for the entitie sets
        HashMap<AttributeKey,Object> attributes;
        attributes = new HashMap<AttributeKey,Object>();
        attributes.put(AttributeKeys.FILL_COLOR, RelationalERDiagram.ENTITY_FILL_COLOR);
        attributes.put(AttributeKeys.STROKE_COLOR, RelationalERDiagram.ENTITY_STROKE_COLOR);
        attributes.put(AttributeKeys.TEXT_COLOR, RelationalERDiagram.ENTITY_TEXT_COLOR);
        
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.rer.Labels");
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        
        ButtonFactory.addSelectionToolTo(tb, editor);
        tb.addSeparator();
        
        EntityFigure ef;
        RelationshipFigure rf;
        
        ButtonFactory.addToolTo(tb, editor, new CreationTool(ef = new EntityFigure(Entity.TYPE_FUNDAMENTAL), attributes), "createEntityFundamental", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(ef = new EntityFigure(Entity.TYPE_ATTRIBUTIVE), attributes), "createEntityAttributive", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(ef = new EntityFigure(Entity.TYPE_ASSOCIATIVE), attributes), "createEntityAssociative", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(ef = new EntityFigure(Entity.TYPE_SUPERTYPE), attributes), "createEntitySupertype", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(ef = new EntityFigure(Entity.TYPE_SUBTYPE), attributes), "createEntitySubtype", labels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(rf = new RelationshipFigure(), attributes), "createRelationship11", labels);
        rf.getModel().setStartCardinality(1);
        rf.getModel().setEndCardinality(1);
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(rf = new RelationshipFigure(), attributes), "createRelationship1M", labels);
        rf.getModel().setStartCardinality(1);
        rf.getModel().setEndCardinality(Relationship.MANY_CARDINALITY);
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(rf = new RelationshipFigure(), attributes), "createRelationshipMM", labels);
        rf.getModel().setStartCardinality(Relationship.MANY_CARDINALITY);
        rf.getModel().setEndCardinality(Relationship.MANY_CARDINALITY);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new TextAreaCreationTool(new TextAreaFigure()), "createTextArea", drawLabels);
        
    }
    /**
     * Creates toolbars for the application.
     * This class always returns an empty list. Subclasses may return other
     * values.
     */
    @Override
    public List<JToolBar> createToolBars(Application a, View pr) {
        ResourceBundleUtil appLabels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.rer.Labels");
        RERView p = (RERView) pr;
        
        DrawingEditor editor;
        if (p == null) {
            editor = getSharedEditor();
        } else {
            editor = p.getDrawingEditor();
        }
        
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb;
        tb = new JToolBar();
        addStandardButtonsTo(tb, a,pr);
        list.add(tb);
        tb.setName(appLabels.getString("standardToolBarTitle"));
        tb = new JToolBar();
        addCreationButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("drawToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAttributesButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("attributesToolBarTitle"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("alignmentToolBarTitle"));
        list.add(tb);
        tb = new JToolBar(labels.getString("toolBarHTML"));
        HTMLToolBarFactory.addHTMLButtonsTo(tb);
        list.add(tb);
        return list;
    }
    
    @Override
    protected MenuBuilder createMenuBuilder() {
        RERMenuBuilder mb = new RERMenuBuilder();
        mb.setSuppressIcons(true);
        return mb;
    }

    @Override
    public URIChooser createOpenChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing .xml","xml"));
        return c;
    }

    @Override
    public URIChooser createSaveChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing .xml","xml"));
        return c;
    }
    @Override
    public URIChooser createExportChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("HTML .html","html"));
        return c;
    }
}
